﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.FTP.MVI.Messages;
using MVIMessages = VRM.Integration.Mvi.PersonSearch.Messages;

namespace VRM.Integration.FTP.MVI.Transformer
{
    public static class MVIResponseTransformer
    {
        public static FTPPersonSearchResponse TransformRetrieveOrSearchPersonResponse(MVIMessages.RetrieveOrSearchPersonResponse mviResponse)
        {
            if (mviResponse == null)
                return null;

            var response = new FTPPersonSearchResponse();

            response.ExceptionOccured = mviResponse.ExceptionOccured;
            response.MVIMessage = mviResponse.Message;
            response.RawMviExceptionMessage = mviResponse.RawMviExceptionMessage;

            if (mviResponse.ExceptionOccured)
                return response;

            #region map mviperson

            System.Collections.Generic.List<PatientPerson> people = new System.Collections.Generic.List<PatientPerson>();
            if (mviResponse.Person != null)
            {
                foreach (var thisPerson in mviResponse.Person)
                {

                    var newPerson = new PatientPerson();
                    #region address
                    newPerson.Address = new PatientAddress();
                    if (thisPerson.Address != null)
                    {
                        newPerson.Address.City = thisPerson.Address.City;
                        newPerson.Address.Country = thisPerson.Address.Country;
                        newPerson.Address.PostalCode = thisPerson.Address.PostalCode;
                        newPerson.Address.State = thisPerson.Address.State;
                        newPerson.Address.StreetAddressLine = thisPerson.Address.StreetAddressLine;
                        //newPerson.Address.Use == new PatientAddress.                       

                    }
                    #endregion

                    if (!string.IsNullOrEmpty(thisPerson.BirthDate))
                    {
                        newPerson.BirthDate = FormatDate(thisPerson.BirthDate);
                    }
                    if (!string.IsNullOrEmpty(thisPerson.DeceasedDate))
                    {
                        newPerson.DeceasedDate = FormatDate(thisPerson.DeceasedDate);
                    }
                    #region corresponding IDs
                    System.Collections.Generic.List<CorrespondingIDs> ids = new System.Collections.Generic.List<CorrespondingIDs>();
                    if (thisPerson.CorrespondingIdList != null)
                    {
                        foreach (var thisPersonIds in thisPerson.CorrespondingIdList)
                        {
                            var thisId = new CorrespondingIDs();
                            thisId.AssigningAuthority = thisPersonIds.AssigningAuthority;
                            thisId.AssigningFacility = thisPersonIds.AssigningFacility;
                            thisId.FetchMessageProcessType = thisPersonIds.FetchMessageProcessType;
                            thisId.IdentifierType = thisPersonIds.IdentifierType;
                            thisId.OrganizationName = thisPersonIds.OrganizationName;
                            thisId.PatientIdentifier = thisPersonIds.PatientIdentifier;
                            thisId.RawValueFromMvi = thisPersonIds.RawValueFromMvi;
                            thisId.UserFirstName = thisPersonIds.UserFirstName;
                            thisId.UserId = thisPersonIds.UserId;
                            thisId.UserLastName = thisPersonIds.UserLastName;
                            ids.Add(thisId);
                        }
                        newPerson.CorrespondingIdList = ids.ToArray();
                    }
                    #endregion

                    newPerson.EdiPi = thisPerson.EdiPi;
                    newPerson.GenderCode = thisPerson.GenderCode;
                    newPerson.Identifier = thisPerson.Identifier;
                    newPerson.IdentifierType = thisPerson.IdentifierType;
                    newPerson.IdentifyTheft = thisPerson.IdentifyTheft;
                    newPerson.IsDeceased = thisPerson.IsDeceased;
                    newPerson.ParticipantId = thisPerson.ParticipantId;
                    newPerson.PhoneNumber = thisPerson.PhoneNumber;
                    newPerson.RecordSource = thisPerson.RecordSource;
                    newPerson.SocialSecurityNumber = thisPerson.SocialSecurityNumber;
                    //    newPerson.SSId = MCSHelper.ConvertToSecureString(thisPerson.SocialSecurityNumber);
                    newPerson.StatusCode = thisPerson.StatusCode;

                    #region namelist
                    System.Collections.Generic.List<Name> names = new System.Collections.Generic.List<Name>();
                    if (thisPerson.NameList != null)
                    {
                        foreach (var thisName in thisPerson.NameList)
                        {
                            var newName = new Name();
                            newName.FamilyName = thisName.FamilyName;
                            newName.GivenName = thisName.GivenName;
                            newName.MiddleName = thisName.MiddleName;
                            newName.NamePrefix = thisName.NamePrefix;
                            newName.NameSuffix = thisName.NameSuffix;
                            newName.NameType = thisName.NameType;

                            names.Add(newName);
                        }
                        newPerson.NameList = names.ToArray();
                    }
                    #endregion
                    people.Add(newPerson);
                }
                response.Person = people.ToArray();
            }
            #endregion

            return response;            
        }

        //public FTPCorrespondingIdsResponse TransformCorrespondingIdsResponse(MVIMessages.CorrespondingIdsResponse mviResponse)
        //{
        //    if (mviResponse == null)
        //        return null;

        //    var response = new FTPCorrespondingIdsResponse
        //    {
        //        ExceptionOccured = mviResponse.ExceptionOccured,
        //        Message = mviResponse.Message,
        //        RawMviExceptionMessage = mviResponse.RawMviExceptionMessage
        //    };


        //    if (mviResponse.ExceptionOccured)
        //        return response;

        //    Mapper.Initialize(m =>
        //    {
        //        m.CreateMap<MVIMessages.CorrespondingIdsResponse, FTPCorrespondingIdsResponse>();
        //        m.CreateMap<MVIMessages.UnattendedSearchRequest, CorrespondingIDs>();
        //    });

        //    if (mviResponse.CorrespondingIdList == null || mviResponse.CorrespondingIdList.Length == 0)
        //        return response;
        //    response.CorrespondingIdList = Mapper.Map<MVIMessages.UnattendedSearchRequest[], CorrespondingIDs[]>(mviResponse.CorrespondingIdList);


        //    return response;
        //}

        public static FTPCorrespondingIdsResponse TransformRetrieveOrSearchPersonToCorrespondingIdsResponse(MVIMessages.RetrieveOrSearchPersonResponse mviResponse)
        {
            if (mviResponse == null)
            {
                return new FTPCorrespondingIdsResponse()
                {
                    ExceptionOccured = true,
                    Message = "Null Response from MVI"
                };
            }

            if ((mviResponse.Person == null) || (mviResponse.Person.Length == 0))
            {
                return new FTPCorrespondingIdsResponse()
                {
                    ExceptionOccured = true,
                    Message = "MVI Response missing Person"
                };
            }

            var response = new FTPCorrespondingIdsResponse()
            {
                ExceptionOccured = mviResponse.ExceptionOccured,
                Message = mviResponse.Message,
                RawMviExceptionMessage = mviResponse.RawMviExceptionMessage,
                OrganizationName = mviResponse.OrganizationName,
                ParticipantId = mviResponse.Person[0].ParticipantId,
                Edipi = mviResponse.Person[0].EdiPi,
                FirstName = mviResponse.Person[0].NameList[0].GivenName,
                MiddleName = mviResponse.Person[0].NameList[0].MiddleName,
                FamilyName = mviResponse.Person[0].NameList[0].FamilyName,
                FullAddress = mviResponse.Person[0].FullAddress,
                FullName = mviResponse.Person[0].FullName,
                DateofBirth = mviResponse.Person[0].BirthDate,
                SocialSecurityNumber = mviResponse.Person[0].SocialSecurityNumber
            };

            //Mapper.Initialize(m =>
            //{
            //    m.CreateMap<MVIMessages.CorrespondingIdsResponse, FTPCorrespondingIdsResponse>();
            //    m.CreateMap<MVIMessages.UnattendedSearchRequest, CorrespondingIDs>();
            //});

            if (mviResponse.Person[0].CorrespondingIdList == null || mviResponse.Person[0].CorrespondingIdList.Length == 0)
                return response;

            #region corresponding IDs
            System.Collections.Generic.List<CorrespondingIDs> ids = new System.Collections.Generic.List<CorrespondingIDs>();
            if (mviResponse.Person[0].CorrespondingIdList != null)
            {
                foreach (var thisPersonIds in mviResponse.Person[0].CorrespondingIdList)
                {
                    var thisId = new CorrespondingIDs();
                    thisId.AssigningAuthority = thisPersonIds.AssigningAuthority;
                    thisId.AssigningFacility = thisPersonIds.AssigningFacility;
                    thisId.FetchMessageProcessType = thisPersonIds.FetchMessageProcessType;
                    thisId.IdentifierType = thisPersonIds.IdentifierType;
                    thisId.OrganizationName = thisPersonIds.OrganizationName;
                    thisId.PatientIdentifier = thisPersonIds.PatientIdentifier;
                    thisId.RawValueFromMvi = thisPersonIds.RawValueFromMvi;
                    thisId.UserFirstName = thisPersonIds.UserFirstName;
                    thisId.UserId = thisPersonIds.UserId;
                    thisId.UserLastName = thisPersonIds.UserLastName;
                    ids.Add(thisId);
                }
                response.CorrespondingIdList = ids.ToArray();
            }
            #endregion

            return response;
        }

        private static string FormatDate(string dateString, string format = "yyyyMMdd")
        {
            DateTime date;
            try
            {
                date = DateTime.ParseExact(dateString, "yyyyMMdd", System.Globalization.CultureInfo.InvariantCulture, System.Globalization.DateTimeStyles.None);
                return date.ToString("MM/dd/yyyy");
            }
            catch (FormatException dateFormatException)
            {
                //If date cannot be reformatted return the date present in the system.
                return dateString;
            }
            catch (ArgumentException dateArgumentException)
            {
                //If date cannot be reformatted return the date present in the system.
                return dateString;
            }
        }
    }
}
